%------------------------------------------------------------------------------
% File     : DAT202^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 108
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__108.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  327 ( 109 unt;  50 typ;   0 def)
%            Number of atoms       :  796 ( 385 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4474 ( 135   ~;  13   |;  96   &;3826   @)
%                                         (   0 <=>; 404  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   25 (   8 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  211 ( 211   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   52 (  49 usr;   7 con; 0-5 aty)
%            Number of variables   : 1165 (  31   ^;1028   !;  62   ?;1165   :)
%                                         (  44  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:40:40.207
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (46)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ominus,type,
    minus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Ocan__select,type,
    can_select: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_List_Ocoset,type,
    coset: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ocase__list,type,
    case_list: 
      !>[B: $tType,A: $tType] : ( B > ( A > ( list @ A ) > B ) > ( list @ A ) > B ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist_Otl,type,
    tl: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ B ) ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Oremdups__adj,type,
    remdups_adj: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Osublists,type,
    sublists: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List__More_Ocombinatorial__product,type,
    list_c659805718roduct: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Misc_Omergesort__remdups,type,
    mergesort_remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Odiff__sorted,type,
    sorted1267110213sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l1a____,type,
    l1a: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

thf(sy_v_l2a____,type,
    l2a: list @ a ).

thf(sy_v_x1____,type,
    x1: a ).

%----Relevant facts (255)
thf(fact_0_Nil_Oprems,axiom,
    ( ( distinct @ a @ ( nil @ a ) )
    & ( linorder_sorted @ a @ ( nil @ a ) ) ) ).

% Nil.prems
thf(fact_1_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_2_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_3_l2__props,axiom,
    ( ( distinct @ a @ l2a )
    & ( linorder_sorted @ a @ l2a ) ) ).

% l2_props
thf(fact_4_x1__l1__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x1 @ l1a ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x1 @ l1a ) ) ) ).

% x1_l1_props
thf(fact_5_l1__props,axiom,
    ( ( distinct @ a @ l1a )
    & ( linorder_sorted @ a @ l1a ) ) ).

% l1_props
thf(fact_6_x1__nin__l1,axiom,
    ~ ( member @ a @ x1 @ ( set2 @ a @ l1a ) ) ).

% x1_nin_l1
thf(fact_7_Cons_Ohyps,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ l1a )
        & ( linorder_sorted @ a @ l1a ) )
     => ( ( ( distinct @ a @ L2 )
          & ( linorder_sorted @ a @ L2 ) )
       => ( ( distinct @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
          & ( linorder_sorted @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
          & ( ( set2 @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
            = ( minus_minus @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ) ) ).

% Cons.hyps
thf(fact_8_ind__hyp__l1,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ L2 )
        & ( linorder_sorted @ a @ L2 ) )
     => ( ( distinct @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
        & ( linorder_sorted @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
        & ( ( set2 @ a @ ( sorted1267110213sorted @ a @ l1a @ L2 ) )
          = ( minus_minus @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ) ).

% ind_hyp_l1
thf(fact_9_diff__sorted_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [V: A,Va: list @ A] :
          ( ( sorted1267110213sorted @ A @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
          = ( cons @ A @ V @ Va ) ) ) ).

% diff_sorted.simps(2)
thf(fact_10_diff__sorted_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] :
          ( ( sorted1267110213sorted @ A @ ( nil @ A ) @ L2 )
          = ( nil @ A ) ) ) ).

% diff_sorted.simps(1)
thf(fact_11_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( linorder_sorted @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_12_x1__le,axiom,
    ! [X: a] :
      ( ( member @ a @ X @ ( set2 @ a @ l1a ) )
     => ( ord_less_eq @ a @ x1 @ X ) ) ).

% x1_le
thf(fact_13_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_14_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X @ Xs ) )
      = ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_15_distinct__singleton,axiom,
    ! [A: $tType,X: A] : ( distinct @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_16_DiffI,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ A2 )
     => ( ~ ( member @ A @ C @ B2 )
       => ( member @ A @ C @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% DiffI
thf(fact_17_Diff__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( member @ A @ C @ A2 )
        & ~ ( member @ A @ C @ B2 ) ) ) ).

% Diff_iff
thf(fact_18_Diff__idemp,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) @ B2 )
      = ( minus_minus @ ( set @ A ) @ A2 @ B2 ) ) ).

% Diff_idemp
thf(fact_19_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_20_minus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A3: A > B,B3: A > B,X2: A] : ( minus_minus @ B @ ( A3 @ X2 ) @ ( B3 @ X2 ) ) ) ) ) ).

% minus_apply
thf(fact_21_sorted_ONil,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_sorted @ A @ ( nil @ A ) ) ) ).

% sorted.Nil
thf(fact_22_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_23_sorted__many__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) ) ) ) ) ).

% sorted_many_eq
thf(fact_24_sorted__many,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) ) ) ) ) ).

% sorted_many
thf(fact_25_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X2: A] :
                ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X @ X2 ) ) ) ) ) ).

% sorted_Cons
thf(fact_26_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X: A] :
          ( ! [X3: A] :
              ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X @ X3 ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_27_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A,P: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X )
         => ( ( P @ ( nil @ A ) )
           => ( ! [Xs2: list @ A,X3: A] :
                  ( ! [Xa: A] :
                      ( ( member @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X3 @ Xa ) )
                 => ( ( linorder_sorted @ A @ Xs2 )
                   => ( ( P @ Xs2 )
                     => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) ) )
             => ( P @ X ) ) ) ) ) ).

% sorted.inducts
thf(fact_28_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A4: list @ A] :
              ( ( A4
                = ( nil @ A ) )
              | ? [Xs3: list @ A,X2: A] :
                  ( ( A4
                    = ( cons @ A @ X2 @ Xs3 ) )
                  & ! [Y2: A] :
                      ( ( member @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X2 @ Y2 ) )
                  & ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_29_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A5: list @ A] :
          ( ( linorder_sorted @ A @ A5 )
         => ( ( A5
             != ( nil @ A ) )
           => ~ ! [Xs2: list @ A,X3: A] :
                  ( ( A5
                    = ( cons @ A @ X3 @ Xs2 ) )
                 => ( ! [Xa: A] :
                        ( ( member @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                       => ( ord_less_eq @ A @ X3 @ Xa ) )
                   => ~ ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_30_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A3: A > B,B3: A > B,X2: A] : ( minus_minus @ B @ ( A3 @ X2 ) @ ( B3 @ X2 ) ) ) ) ) ).

% fun_diff_def
thf(fact_31_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_32_DiffD2,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) )
     => ~ ( member @ A @ C @ B2 ) ) ).

% DiffD2
thf(fact_33_DiffD1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) )
     => ( member @ A @ C @ A2 ) ) ).

% DiffD1
thf(fact_34_DiffE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) )
     => ~ ( ( member @ A @ C @ A2 )
         => ( member @ A @ C @ B2 ) ) ) ).

% DiffE
thf(fact_35_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F: A > B,X1: list @ B] : ( P @ F @ ( nil @ A ) @ X1 )
     => ( ! [F: A > B,A6: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F @ As @ ( cons @ B @ ( F @ A6 ) @ Bs ) )
           => ( P @ F @ ( cons @ A @ A6 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_36_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_37_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y3: A,Xs2: list @ A] :
              ( ( ( X3 = Y3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
             => ( ( ( X3 != Y3 )
                 => ( P @ ( cons @ A @ Y3 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_38_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y3: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_39_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X3: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_40_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [V2: A,Va2: list @ A] : ( P @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ A ) )
       => ( ! [X3: A,Xs2: list @ A,Y3: A,Ys2: list @ A] :
              ( ( P @ Xs2 @ Ys2 )
             => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys2 ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_41_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y3: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y3 @ Ys2 ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys2: list @ B] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y3 @ Ys2 ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_42_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y2: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y2 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_43_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X1: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X1 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A5: A,P: A > $o] :
      ( ( member @ A @ A5 @ ( collect @ A @ P ) )
      = ( P @ A5 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F2 @ X3 )
          = ( G @ X3 ) )
     => ( F2 = G ) ) ).

% ext
thf(fact_48_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_49_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_50_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_51_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A5: list @ A] :
      ( ( member @ A @ E @ ( set2 @ A @ A5 ) )
     => ( ! [Z2: list @ A] :
            ( A5
           != ( cons @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ A] :
              ( ( A5
                = ( cons @ A @ Z1 @ Z2 ) )
             => ~ ( member @ A @ E @ ( set2 @ A @ Z2 ) ) ) ) ) ).

% list.set_cases
thf(fact_52_set__ConsD,axiom,
    ! [A: $tType,Y: A,X: A,Xs: list @ A] :
      ( ( member @ A @ Y @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) )
     => ( ( Y = X )
        | ( member @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_53_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_54_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X: A,A22: list @ A,A1: A] :
      ( ( member @ A @ X @ ( set2 @ A @ A22 ) )
     => ( member @ A @ X @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_55_distinct__length__2__or__more,axiom,
    ! [A: $tType,A5: A,B4: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A5 @ ( cons @ A @ B4 @ Xs ) ) )
      = ( ( A5 != B4 )
        & ( distinct @ A @ ( cons @ A @ A5 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B4 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_56_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_57_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_58_the__elem__set,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = X ) ).

% the_elem_set
thf(fact_59_quicksort_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X3: A,Xs2: list @ A] :
                ( X
               != ( cons @ A @ X3 @ Xs2 ) ) ) ) ).

% quicksort.cases
thf(fact_60_mergesort__by__rel__merge__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,R: A > B > $o,Xs: list @ A,Ys: list @ B] :
      ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ B ) )
     => ( ! [X1: list @ B] : ( P @ ( nil @ A ) @ X1 )
       => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys2: list @ B] :
              ( ( R @ X3 @ Y3 )
             => ( ( P @ Xs2 @ ( cons @ B @ Y3 @ Ys2 ) )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y3 @ Ys2 ) ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys2: list @ B] :
                ( ~ ( R @ X3 @ Y3 )
               => ( ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys2 )
                 => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y3 @ Ys2 ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_induct
thf(fact_61_mergesort__by__rel__merge_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ! [R2: A > A > $o,X3: A,Xs2: list @ A,Y3: A,Ys2: list @ A] :
          ( ( ( R2 @ X3 @ Y3 )
           => ( P @ R2 @ Xs2 @ ( cons @ A @ Y3 @ Ys2 ) ) )
         => ( ( ~ ( R2 @ X3 @ Y3 )
             => ( P @ R2 @ ( cons @ A @ X3 @ Xs2 ) @ Ys2 ) )
           => ( P @ R2 @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y3 @ Ys2 ) ) ) )
     => ( ! [R2: A > A > $o,Xs2: list @ A] : ( P @ R2 @ Xs2 @ ( nil @ A ) )
       => ( ! [R2: A > A > $o,V2: A,Va2: list @ A] : ( P @ R2 @ ( nil @ A ) @ ( cons @ A @ V2 @ Va2 ) )
         => ( P @ A0 @ A1 @ A22 ) ) ) ) ).

% mergesort_by_rel_merge.induct
thf(fact_62_list__all__zip_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > $o,A1: list @ A,A22: list @ B] :
      ( ! [P2: A > B > $o] : ( P @ P2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [P2: A > B > $o,A6: A,As: list @ A,B5: B,Bs: list @ B] :
            ( ( P @ P2 @ As @ Bs )
           => ( P @ P2 @ ( cons @ A @ A6 @ As ) @ ( cons @ B @ B5 @ Bs ) ) )
       => ( ! [P2: A > B > $o,V2: A,Va2: list @ A] : ( P @ P2 @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ B ) )
         => ( ! [P2: A > B > $o,V2: B,Va2: list @ B] : ( P @ P2 @ ( nil @ A ) @ ( cons @ B @ V2 @ Va2 ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% list_all_zip.induct
thf(fact_63_list__induct__first2,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X1: A,X23: A,Xs2: list @ A] :
              ( ( P @ Xs2 )
             => ( P @ ( cons @ A @ X1 @ ( cons @ A @ X23 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_induct_first2
thf(fact_64_list__2pre__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,W1: list @ A,W2: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [E2: A,W12: list @ A,W22: list @ B] :
            ( ( P @ W12 @ W22 )
           => ( P @ ( cons @ A @ E2 @ W12 ) @ W22 ) )
       => ( ! [E2: B,W13: list @ A,W23: list @ B] :
              ( ( P @ W13 @ W23 )
             => ( P @ W13 @ ( cons @ B @ E2 @ W23 ) ) )
         => ( P @ W1 @ W2 ) ) ) ) ).

% list_2pre_induct
thf(fact_65_zipf_Oinduct,axiom,
    ! [A: $tType,C2: $tType,B: $tType,P: ( A > B > C2 ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > C2,A1: list @ A,A22: list @ B] :
      ( ! [F: A > B > C2] : ( P @ F @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [F: A > B > C2,A6: A,As: list @ A,B5: B,Bs: list @ B] :
            ( ( P @ F @ As @ Bs )
           => ( P @ F @ ( cons @ A @ A6 @ As ) @ ( cons @ B @ B5 @ Bs ) ) )
       => ( ! [A6: A > B > C2,V2: A,Va2: list @ A] : ( P @ A6 @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ B ) )
         => ( ! [A6: A > B > C2,V2: B,Va2: list @ B] : ( P @ A6 @ ( nil @ A ) @ ( cons @ B @ V2 @ Va2 ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% zipf.induct
thf(fact_66_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B2 )
      = ( ! [X2: A] :
            ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
           => ( member @ A @ X2 @ B2 ) ) ) ) ).

% subset_code(1)
thf(fact_67_Diff__mono,axiom,
    ! [A: $tType,A2: set @ A,C3: set @ A,D: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ C3 )
     => ( ( ord_less_eq @ ( set @ A ) @ D @ B2 )
       => ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) @ ( minus_minus @ ( set @ A ) @ C3 @ D ) ) ) ) ).

% Diff_mono
thf(fact_68_Diff__subset,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A2 @ B2 ) @ A2 ) ).

% Diff_subset
thf(fact_69_double__diff,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C3 )
       => ( ( minus_minus @ ( set @ A ) @ B2 @ ( minus_minus @ ( set @ A ) @ C3 @ A2 ) )
          = A2 ) ) ) ).

% double_diff
thf(fact_70_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_71_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B4: A,A5: A] :
          ( ( ord_less_eq @ A @ B4 @ A5 )
         => ( ( ord_less_eq @ A @ A5 @ B4 )
           => ( A5 = B4 ) ) ) ) ).

% dual_order.antisym
thf(fact_72_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B4: A,A5: A,C: A] :
          ( ( ord_less_eq @ A @ B4 @ A5 )
         => ( ( ord_less_eq @ A @ C @ B4 )
           => ( ord_less_eq @ A @ C @ A5 ) ) ) ) ).

% dual_order.trans
thf(fact_73_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A5: A,B4: A] :
          ( ! [A6: A,B5: A] :
              ( ( ord_less_eq @ A @ A6 @ B5 )
             => ( P @ A6 @ B5 ) )
         => ( ! [A6: A,B5: A] :
                ( ( P @ B5 @ A6 )
               => ( P @ A6 @ B5 ) )
           => ( P @ A5 @ B4 ) ) ) ) ).

% linorder_wlog
thf(fact_74_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A5: A] : ( ord_less_eq @ A @ A5 @ A5 ) ) ).

% dual_order.refl
thf(fact_75_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_76_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( ord_less_eq @ A @ B4 @ A5 )
           => ( A5 = B4 ) ) ) ) ).

% order_class.order.antisym
thf(fact_77_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( B4 = C )
           => ( ord_less_eq @ A @ A5 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_78_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A] :
          ( ( A5 = B4 )
         => ( ( ord_less_eq @ A @ B4 @ C )
           => ( ord_less_eq @ A @ A5 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_79_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_80_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_81_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( ord_less_eq @ A @ B4 @ C )
           => ( ord_less_eq @ A @ A5 @ C ) ) ) ) ).

% order.trans
thf(fact_82_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_83_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_84_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_85_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_86_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y4: A,Z3: A] : ( Y4 = Z3 ) )
        = ( ^ [X2: A,Y2: A] :
              ( ( ord_less_eq @ A @ X2 @ Y2 )
              & ( ord_less_eq @ A @ Y2 @ X2 ) ) ) ) ) ).

% eq_iff
thf(fact_87_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A5: A,B4: A,F2: A > B,C: B] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( ( F2 @ B4 )
              = C )
           => ( ! [X3: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y3 )
                 => ( ord_less_eq @ B @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ B @ ( F2 @ A5 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_88_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A5: A,F2: B > A,B4: B,C: B] :
          ( ( A5
            = ( F2 @ B4 ) )
         => ( ( ord_less_eq @ B @ B4 @ C )
           => ( ! [X3: B,Y3: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A5 @ ( F2 @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_89_ord__eq__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A,D2: A] :
          ( ( A5 = B4 )
         => ( ( ord_less_eq @ A @ B4 @ C )
           => ( ( C = D2 )
             => ( ord_less_eq @ A @ A5 @ D2 ) ) ) ) ) ).

% ord_eq_le_eq_trans
thf(fact_90_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A5: A,B4: A,F2: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( ord_less_eq @ C2 @ ( F2 @ B4 ) @ C )
           => ( ! [X3: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y3 )
                 => ( ord_less_eq @ C2 @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ C2 @ ( F2 @ A5 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_91_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A5: A,F2: B > A,B4: B,C: B] :
          ( ( ord_less_eq @ A @ A5 @ ( F2 @ B4 ) )
         => ( ( ord_less_eq @ B @ B4 @ C )
           => ( ! [X3: B,Y3: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A5 @ ( F2 @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_92_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F3: A > B,G2: A > B] :
            ! [X2: A] : ( ord_less_eq @ B @ ( F3 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% le_fun_def
thf(fact_93_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F2: A > B,G: A > B] :
          ( ! [X3: A] : ( ord_less_eq @ B @ ( F2 @ X3 ) @ ( G @ X3 ) )
         => ( ord_less_eq @ ( A > B ) @ F2 @ G ) ) ) ).

% le_funI
thf(fact_94_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F2: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F2 @ G )
         => ( ord_less_eq @ B @ ( F2 @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_95_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F2: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F2 @ G )
         => ( ord_less_eq @ B @ ( F2 @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_96_list__tail__coinc,axiom,
    ! [A: $tType,N1: A,R1: list @ A,N2: A,R22: list @ A] :
      ( ( ( cons @ A @ N1 @ R1 )
        = ( cons @ A @ N2 @ R22 ) )
     => ( ( N1 = N2 )
        & ( R1 = R22 ) ) ) ).

% list_tail_coinc
thf(fact_97_revg_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [A6: A,As: list @ A,B5: list @ A] :
            ( ( P @ As @ ( cons @ A @ A6 @ B5 ) )
           => ( P @ ( cons @ A @ A6 @ As ) @ B5 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% revg.induct
thf(fact_98_mergesort__remdups__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( distinct @ A @ ( mergesort_remdups @ A @ L ) )
          & ( linorder_sorted @ A @ ( mergesort_remdups @ A @ L ) )
          & ( ( set2 @ A @ ( mergesort_remdups @ A @ L ) )
            = ( set2 @ A @ L ) ) ) ) ).

% mergesort_remdups_correct
thf(fact_99_sublists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( sublists @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% sublists.simps(1)
thf(fact_100_diff__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,D2: A,C: A] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ( ord_less_eq @ A @ D2 @ C )
           => ( ord_less_eq @ A @ ( minus_minus @ A @ A5 @ C ) @ ( minus_minus @ A @ B4 @ D2 ) ) ) ) ) ).

% diff_mono
thf(fact_101_diff__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B4: A,A5: A,C: A] :
          ( ( ord_less_eq @ A @ B4 @ A5 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ C @ A5 ) @ ( minus_minus @ A @ C @ B4 ) ) ) ) ).

% diff_left_mono
thf(fact_102_diff__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A] :
          ( ( ord_less_eq @ A @ A5 @ B4 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ A5 @ C ) @ ( minus_minus @ A @ B4 @ C ) ) ) ) ).

% diff_right_mono
thf(fact_103_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A,D2: A] :
          ( ( ( minus_minus @ A @ A5 @ B4 )
            = ( minus_minus @ A @ C @ D2 ) )
         => ( ( ord_less_eq @ A @ A5 @ B4 )
            = ( ord_less_eq @ A @ C @ D2 ) ) ) ) ).

% diff_eq_diff_less_eq
thf(fact_104_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_105_subsetI,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A2 )
         => ( member @ A @ X3 @ B2 ) )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ).

% subsetI
thf(fact_106_subset__antisym,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ A2 )
       => ( A2 = B2 ) ) ) ).

% subset_antisym
thf(fact_107_set__mp,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member @ A @ X @ A2 )
       => ( member @ A @ X @ B2 ) ) ) ).

% set_mp
thf(fact_108_in__mono,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member @ A @ X @ A2 )
       => ( member @ A @ X @ B2 ) ) ) ).

% in_mono
thf(fact_109_subsetD,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member @ A @ C @ A2 )
       => ( member @ A @ C @ B2 ) ) ) ).

% subsetD
thf(fact_110_subsetCE,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member @ A @ C @ A2 )
       => ( member @ A @ C @ B2 ) ) ) ).

% subsetCE
thf(fact_111_equalityE,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B2 @ A2 ) ) ) ).

% equalityE
thf(fact_112_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B3: set @ A] :
          ! [X2: A] :
            ( ( member @ A @ X2 @ A3 )
           => ( member @ A @ X2 @ B3 ) ) ) ) ).

% subset_eq
thf(fact_113_equalityD1,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ).

% equalityD1
thf(fact_114_equalityD2,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ B2 @ A2 ) ) ).

% equalityD2
thf(fact_115_set__rev__mp,axiom,
    ! [A: $tType,X: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ X @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
       => ( member @ A @ X @ B2 ) ) ) ).

% set_rev_mp
thf(fact_116_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A3: set @ A,B3: set @ A] :
          ! [T: A] :
            ( ( member @ A @ T @ A3 )
           => ( member @ A @ T @ B3 ) ) ) ) ).

% subset_iff
thf(fact_117_rev__subsetD,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
       => ( member @ A @ C @ B2 ) ) ) ).

% rev_subsetD
thf(fact_118_subset__refl,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ A2 ) ).

% subset_refl
thf(fact_119_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_120_subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C3 )
       => ( ord_less_eq @ ( set @ A ) @ A2 @ C3 ) ) ) ).

% subset_trans
thf(fact_121_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y4: set @ A,Z3: set @ A] : ( Y4 = Z3 ) )
      = ( ^ [A3: set @ A,B3: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
            & ( ord_less_eq @ ( set @ A ) @ B3 @ A3 ) ) ) ) ).

% set_eq_subset
thf(fact_122_contra__subsetD,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ~ ( member @ A @ C @ B2 )
       => ~ ( member @ A @ C @ A2 ) ) ) ).

% contra_subsetD
thf(fact_123_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X2: A] :
            ( ( P @ X2 )
           => ( Q @ X2 ) ) ) ) ).

% Collect_mono_iff
thf(fact_124_subset__Collect__conv,axiom,
    ! [A: $tType,S: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ ( collect @ A @ P ) )
      = ( ! [X2: A] :
            ( ( member @ A @ X2 @ S )
           => ( P @ X2 ) ) ) ) ).

% subset_Collect_conv
thf(fact_125_distinct__product__lists,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A )] :
      ( ! [X3: list @ A] :
          ( ( member @ ( list @ A ) @ X3 @ ( set2 @ ( list @ A ) @ Xss2 ) )
         => ( distinct @ A @ X3 ) )
     => ( distinct @ ( list @ A ) @ ( product_lists @ A @ Xss2 ) ) ) ).

% distinct_product_lists
thf(fact_126_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A5: A,C: A,B4: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A5 @ C ) @ B4 )
          = ( minus_minus @ A @ ( minus_minus @ A @ A5 @ B4 ) @ C ) ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_127_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A5: A,B4: A,C: A,D2: A] :
          ( ( ( minus_minus @ A @ A5 @ B4 )
            = ( minus_minus @ A @ C @ D2 ) )
         => ( ( A5 = B4 )
            = ( C = D2 ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_128_subset__code_I3_J,axiom,
    ! [C2: $tType] :
      ~ ( ord_less_eq @ ( set @ C2 ) @ ( coset @ C2 @ ( nil @ C2 ) ) @ ( set2 @ C2 @ ( nil @ C2 ) ) ) ).

% subset_code(3)
thf(fact_129_not__in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = ( cons @ A @ X @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_130_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_131_combinatorial__product_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( list_c659805718roduct @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% combinatorial_product.simps(1)
thf(fact_132_sorted__append__bigger,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Y: A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ! [X3: A] :
                ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X3 @ Y ) )
           => ( linorder_sorted @ A @ ( append @ A @ Xs @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) ) ) ) ).

% sorted_append_bigger
thf(fact_133_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys ) @ Zs )
      = ( append @ A @ Xs @ ( append @ A @ Ys @ Zs ) ) ) ).

% append_assoc
thf(fact_134_append__same__eq,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Ys @ Xs )
        = ( append @ A @ Zs @ Xs ) )
      = ( Ys = Zs ) ) ).

% append_same_eq
thf(fact_135_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Xs @ Zs ) )
      = ( Ys = Zs ) ) ).

% same_append_eq
thf(fact_136_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_137_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Xs )
      = ( Ys
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_138_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys ) )
      = ( Ys
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_139_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Ys )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_140_self__append__conv2,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
        = ( append @ A @ Xs @ Ys ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_141_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_142_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_143_in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_144_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_145_list__e__eq__lel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E3: A,L2: list @ A,E: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) )
        = ( cons @ A @ E @ ( nil @ A ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(2)
thf(fact_146_list__e__eq__lel_I1_J,axiom,
    ! [A: $tType,E: A,L1: list @ A,E3: A,L2: list @ A] :
      ( ( ( cons @ A @ E @ ( nil @ A ) )
        = ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(1)
thf(fact_147_list__se__match_I4_J,axiom,
    ! [A: $tType,L2: list @ A,A5: A,L1: list @ A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A5 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A5 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(4)
thf(fact_148_list__se__match_I3_J,axiom,
    ! [A: $tType,L1: list @ A,A5: A,L2: list @ A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A5 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( cons @ A @ A5 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(3)
thf(fact_149_list__se__match_I2_J,axiom,
    ! [A: $tType,L2: list @ A,L1: list @ A,A5: A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A5 @ ( nil @ A ) ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A5 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(2)
thf(fact_150_list__se__match_I1_J,axiom,
    ! [A: $tType,L1: list @ A,L2: list @ A,A5: A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A5 @ ( nil @ A ) ) )
        = ( ( L1
            = ( cons @ A @ A5 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(1)
thf(fact_151_list__ee__eq__leel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E1: A,E22: A,L2: list @ A,E12: A,E23: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E1 @ ( cons @ A @ E22 @ L2 ) ) )
        = ( cons @ A @ E12 @ ( cons @ A @ E23 @ ( nil @ A ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E12 = E1 )
        & ( E23 = E22 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(2)
thf(fact_152_list__ee__eq__leel_I1_J,axiom,
    ! [A: $tType,E12: A,E23: A,L1: list @ A,E1: A,E22: A,L2: list @ A] :
      ( ( ( cons @ A @ E12 @ ( cons @ A @ E23 @ ( nil @ A ) ) )
        = ( append @ A @ L1 @ ( cons @ A @ E1 @ ( cons @ A @ E22 @ L2 ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E12 = E1 )
        & ( E23 = E22 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(1)
thf(fact_153_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = ( append @ A @ Ys @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

% append1_eq_conv
thf(fact_154_append__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A] :
      ( ( append @ A @ ( cons @ A @ X @ Xs ) @ Ys )
      = ( cons @ A @ X @ ( append @ A @ Xs @ Ys ) ) ) ).

% append_Cons
thf(fact_155_Cons__eq__appendI,axiom,
    ! [A: $tType,X: A,Xs1: list @ A,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs1 )
        = Ys )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs ) )
       => ( ( cons @ A @ X @ Xs )
          = ( append @ A @ Ys @ Zs ) ) ) ) ).

% Cons_eq_appendI
thf(fact_156_list__match__lel__lel,axiom,
    ! [A: $tType,C1: list @ A,Qs: A,C22: list @ A,C12: list @ A,Qs2: A,C23: list @ A] :
      ( ( ( append @ A @ C1 @ ( cons @ A @ Qs @ C22 ) )
        = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C23 ) ) )
     => ( ! [C21: list @ A] :
            ( ( C1
              = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C21 ) ) )
           => ( C23
             != ( append @ A @ C21 @ ( cons @ A @ Qs @ C22 ) ) ) )
       => ( ( ( C12 = C1 )
           => ( ( Qs2 = Qs )
             => ( C23 != C22 ) ) )
         => ~ ! [C212: list @ A] :
                ( ( C12
                  = ( append @ A @ C1 @ ( cons @ A @ Qs @ C212 ) ) )
               => ( C22
                 != ( append @ A @ C212 @ ( cons @ A @ Qs2 @ C23 ) ) ) ) ) ) ) ).

% list_match_lel_lel
thf(fact_157_append__Nil,axiom,
    ! [A: $tType,Ys: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys )
      = Ys ) ).

% append_Nil
thf(fact_158_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs = Ys )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys ) ) ) ).

% eq_Nil_appendI
thf(fact_159_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs: list @ A,Ys: list @ A,Us: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs )
     => ( ( Ys
          = ( append @ A @ Xs1 @ Us ) )
       => ( ( append @ A @ Xs @ Ys )
          = ( append @ A @ Zs @ Us ) ) ) ) ).

% append_eq_appendI
thf(fact_160_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Zs @ Ts ) )
      = ( ? [Us2: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs @ Us2 ) )
              & ( ( append @ A @ Us2 @ Ys )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us2 )
                = Zs )
              & ( Ys
                = ( append @ A @ Us2 @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_161_rev__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( nil @ B ) )
       => ( ! [Y3: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y3 @ ( nil @ B ) ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys2: list @ B] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y3 @ ( nil @ B ) ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% rev_induct2'
thf(fact_162_list__rev__decomp,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ? [Ll: list @ A,E2: A] :
          ( L
          = ( append @ A @ Ll @ ( cons @ A @ E2 @ ( nil @ A ) ) ) ) ) ).

% list_rev_decomp
thf(fact_163_neq__Nil__rev__conv,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
      = ( ? [Xs3: list @ A,X2: A] :
            ( L
            = ( append @ A @ Xs3 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ) ) ).

% neq_Nil_rev_conv
thf(fact_164_rev__nonempty__induct2_H,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Ys: list @ B,P: ( list @ A ) > ( list @ B ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( Ys
         != ( nil @ B ) )
       => ( ! [X3: A,Y3: B] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) @ ( cons @ B @ Y3 @ ( nil @ B ) ) )
         => ( ! [X3: A,Xs2: list @ A,Y3: B] :
                ( ( Xs2
                 != ( nil @ A ) )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( cons @ B @ Y3 @ ( nil @ B ) ) ) )
           => ( ! [X3: A,Y3: B,Ys2: list @ B] :
                  ( ( Ys2
                   != ( nil @ B ) )
                 => ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y3 @ ( nil @ B ) ) ) ) )
             => ( ! [X3: A,Xs2: list @ A,Y3: B,Ys2: list @ B] :
                    ( ( P @ Xs2 @ Ys2 )
                   => ( ( Xs2
                       != ( nil @ A ) )
                     => ( ( Ys2
                         != ( nil @ B ) )
                       => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y3 @ ( nil @ B ) ) ) ) ) ) )
               => ( P @ Xs @ Ys ) ) ) ) ) ) ) ).

% rev_nonempty_induct2'
thf(fact_165_list__Cons__eq__append__cases,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_Cons_eq_append_cases
thf(fact_166_list__append__eq__Cons__cases,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_append_eq_Cons_cases
thf(fact_167_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_168_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys2: list @ A,Y3: A] :
            ( Xs
           != ( append @ A @ Ys2 @ ( cons @ A @ Y3 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_169_Cons__eq__append__conv,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( ( cons @ A @ X @ Xs )
            = Zs ) )
        | ? [Ys5: list @ A] :
            ( ( ( cons @ A @ X @ Ys5 )
              = Ys )
            & ( Xs
              = ( append @ A @ Ys5 @ Zs ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_170_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( Zs
            = ( cons @ A @ X @ Xs ) ) )
        | ? [Ys5: list @ A] :
            ( ( Ys
              = ( cons @ A @ X @ Ys5 ) )
            & ( ( append @ A @ Ys5 @ Zs )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_171_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_172_xy__in__set__cases,axiom,
    ! [A: $tType,X: A,L: list @ A,Y: A] :
      ( ( member @ A @ X @ ( set2 @ A @ L ) )
     => ( ( member @ A @ Y @ ( set2 @ A @ L ) )
       => ( ( ( X = Y )
           => ! [L12: list @ A,L22: list @ A] :
                ( L
               != ( append @ A @ L12 @ ( cons @ A @ Y @ L22 ) ) ) )
         => ( ( ( X != Y )
             => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                  ( L
                 != ( append @ A @ L12 @ ( cons @ A @ X @ ( append @ A @ L22 @ ( cons @ A @ Y @ L3 ) ) ) ) ) )
           => ~ ( ( X != Y )
               => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                    ( L
                   != ( append @ A @ L12 @ ( cons @ A @ Y @ ( append @ A @ L22 @ ( cons @ A @ X @ L3 ) ) ) ) ) ) ) ) ) ) ).

% xy_in_set_cases
thf(fact_173_in__set__list__format,axiom,
    ! [A: $tType,E: A,L: list @ A] :
      ( ( member @ A @ E @ ( set2 @ A @ L ) )
     => ~ ! [L12: list @ A,L22: list @ A] :
            ( L
           != ( append @ A @ L12 @ ( cons @ A @ E @ L22 ) ) ) ) ).

% in_set_list_format
thf(fact_174_split__list,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs2: list @ A] :
          ( Xs
          = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs2 ) ) ) ) ).

% split_list
thf(fact_175_split__list__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs2: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs2 ) ) )
          & ~ ( member @ A @ X @ ( set2 @ A @ Zs2 ) ) ) ) ).

% split_list_last
thf(fact_176_split__list__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A] :
          ( ? [Zs2: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
          & ( P @ X3 ) ) ) ).

% split_list_prop
thf(fact_177_split__list__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs2: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs2 ) ) )
          & ~ ( member @ A @ X @ ( set2 @ A @ Ys2 ) ) ) ) ).

% split_list_first
thf(fact_178_split__list__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A] :
            ( ? [Zs2: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
           => ~ ( P @ X3 ) ) ) ).

% split_list_propE
thf(fact_179_in__set__conv__decomp,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs3: list @ A] :
            ( Xs
            = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs3 ) ) ) ) ) ).

% in_set_conv_decomp
thf(fact_180_split__list__last__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A,Zs2: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
          & ( P @ X3 )
          & ! [Xa: A] :
              ( ( member @ A @ Xa @ ( set2 @ A @ Zs2 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_last_prop
thf(fact_181_split__list__first__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X3: A] :
          ( ? [Zs2: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
          & ( P @ X3 )
          & ! [Xa: A] :
              ( ( member @ A @ Xa @ ( set2 @ A @ Ys2 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_first_prop
thf(fact_182_split__list__last__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
           => ( ( P @ X3 )
             => ~ ! [Xa: A] :
                    ( ( member @ A @ Xa @ ( set2 @ A @ Zs2 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_last_propE
thf(fact_183_split__list__first__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X3: A] :
            ( ? [Zs2: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X3 @ Zs2 ) ) )
           => ( ( P @ X3 )
             => ~ ! [Xa: A] :
                    ( ( member @ A @ Xa @ ( set2 @ A @ Ys2 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_first_propE
thf(fact_184_in__set__conv__decomp__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs3: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs3 ) ) )
            & ~ ( member @ A @ X @ ( set2 @ A @ Zs3 ) ) ) ) ) ).

% in_set_conv_decomp_last
thf(fact_185_in__set__conv__decomp__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs3: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs3 ) ) )
            & ~ ( member @ A @ X @ ( set2 @ A @ Ys3 ) ) ) ) ) ).

% in_set_conv_decomp_first
thf(fact_186_split__list__last__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
            & ( P @ X2 ) ) )
      = ( ? [Ys3: list @ A,X2: A,Zs3: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X2 @ Zs3 ) ) )
            & ( P @ X2 )
            & ! [Y2: A] :
                ( ( member @ A @ Y2 @ ( set2 @ A @ Zs3 ) )
               => ~ ( P @ Y2 ) ) ) ) ) ).

% split_list_last_prop_iff
thf(fact_187_split__list__first__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
            & ( P @ X2 ) ) )
      = ( ? [Ys3: list @ A,X2: A] :
            ( ? [Zs3: list @ A] :
                ( Xs
                = ( append @ A @ Ys3 @ ( cons @ A @ X2 @ Zs3 ) ) )
            & ( P @ X2 )
            & ! [Y2: A] :
                ( ( member @ A @ Y2 @ ( set2 @ A @ Ys3 ) )
               => ~ ( P @ Y2 ) ) ) ) ) ).

% split_list_first_prop_iff
thf(fact_188_distinct__match,axiom,
    ! [A: $tType,Al: list @ A,E: A,Bl: list @ A,Al2: list @ A,Bl2: list @ A] :
      ( ( distinct @ A @ ( append @ A @ Al @ ( cons @ A @ E @ Bl ) ) )
     => ( ( ( append @ A @ Al @ ( cons @ A @ E @ Bl ) )
          = ( append @ A @ Al2 @ ( cons @ A @ E @ Bl2 ) ) )
        = ( ( Al = Al2 )
          & ( Bl = Bl2 ) ) ) ) ).

% distinct_match
thf(fact_189_not__distinct__decomp,axiom,
    ! [A: $tType,Ws: list @ A] :
      ( ~ ( distinct @ A @ Ws )
     => ? [Xs2: list @ A,Ys2: list @ A,Zs2: list @ A,Y3: A] :
          ( Ws
          = ( append @ A @ Xs2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ Zs2 ) ) ) ) ) ) ).

% not_distinct_decomp
thf(fact_190_sorted__append,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ ( append @ A @ Xs @ Ys ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ( linorder_sorted @ A @ Ys )
            & ! [X2: A] :
                ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ! [Y2: A] :
                    ( ( member @ A @ Y2 @ ( set2 @ A @ Ys ) )
                   => ( ord_less_eq @ A @ X2 @ Y2 ) ) ) ) ) ) ).

% sorted_append
thf(fact_191_not__distinct__conv__prefix,axiom,
    ! [A: $tType,As2: list @ A] :
      ( ( ~ ( distinct @ A @ As2 ) )
      = ( ? [Xs3: list @ A,Y2: A,Ys3: list @ A] :
            ( ( member @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
            & ( distinct @ A @ Xs3 )
            & ( As2
              = ( append @ A @ Xs3 @ ( cons @ A @ Y2 @ Ys3 ) ) ) ) ) ) ).

% not_distinct_conv_prefix
thf(fact_192_subset__code_I2_J,axiom,
    ! [B: $tType,A2: set @ B,Ys: list @ B] :
      ( ( ord_less_eq @ ( set @ B ) @ A2 @ ( coset @ B @ Ys ) )
      = ( ! [X2: B] :
            ( ( member @ B @ X2 @ ( set2 @ B @ Ys ) )
           => ~ ( member @ B @ X2 @ A2 ) ) ) ) ).

% subset_code(2)
thf(fact_193_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X2: A,Xs3: list @ A] : ( if @ ( list @ A ) @ ( member @ A @ X2 @ ( set2 @ A @ Xs3 ) ) @ Xs3 @ ( cons @ A @ X2 @ Xs3 ) ) ) ) ).

% List.insert_def
thf(fact_194_not__distinct__split__distinct,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ~ ( distinct @ A @ Xs )
     => ~ ! [Y3: A,Ys2: list @ A] :
            ( ( distinct @ A @ Ys2 )
           => ( ( member @ A @ Y3 @ ( set2 @ A @ Ys2 ) )
             => ! [Zs2: list @ A] :
                  ( Xs
                 != ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y3 @ ( nil @ A ) ) @ Zs2 ) ) ) ) ) ) ).

% not_distinct_split_distinct
thf(fact_195_bind__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X: B,Xs: list @ B,F2: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( cons @ B @ X @ Xs ) @ F2 )
      = ( append @ A @ ( F2 @ X ) @ ( bind @ B @ A @ Xs @ F2 ) ) ) ).

% bind_simps(2)
thf(fact_196_remove__code_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( remove @ A @ X @ ( coset @ A @ Xs ) )
      = ( coset @ A @ ( insert @ A @ X @ Xs ) ) ) ).

% remove_code(2)
thf(fact_197_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,F2: B > ( list @ A ),X: B,Xs: list @ B] :
      ( ( maps @ B @ A @ F2 @ ( cons @ B @ X @ Xs ) )
      = ( append @ A @ ( F2 @ X ) @ ( maps @ B @ A @ F2 @ Xs ) ) ) ).

% maps_simps(1)
thf(fact_198_rotate1_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( rotate1 @ A @ ( cons @ A @ X @ Xs ) )
      = ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% rotate1.simps(2)
thf(fact_199_member__remove,axiom,
    ! [A: $tType,X: A,Y: A,A2: set @ A] :
      ( ( member @ A @ X @ ( remove @ A @ Y @ A2 ) )
      = ( ( member @ A @ X @ A2 )
        & ( X != Y ) ) ) ).

% member_remove
thf(fact_200_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rotate1 @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rotate1_is_Nil_conv
thf(fact_201_set__rotate1,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rotate1 @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rotate1
thf(fact_202_distinct1__rotate,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ ( rotate1 @ A @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct1_rotate
thf(fact_203_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F2 )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_204_rotate1_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( rotate1 @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% rotate1.simps(1)
thf(fact_205_list__bind__cong,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Ys: list @ A,F2: A > ( list @ B ),G: A > ( list @ B )] :
      ( ( Xs = Ys )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
           => ( ( F2 @ X3 )
              = ( G @ X3 ) ) )
       => ( ( bind @ A @ B @ Xs @ F2 )
          = ( bind @ A @ B @ Ys @ G ) ) ) ) ).

% list_bind_cong
thf(fact_206_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: B > ( list @ A )] :
      ( ( maps @ B @ A @ F2 @ ( nil @ B ) )
      = ( nil @ A ) ) ).

% maps_simps(2)
thf(fact_207_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: A > $o] :
      ~ ( list_ex1 @ A @ P @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_208_sorted__hd__min,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( Xs
           != ( nil @ A ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ! [X4: A] :
                ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ ( hd @ A @ Xs ) @ X4 ) ) ) ) ) ).

% sorted_hd_min
thf(fact_209_hd__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
        = ( hd @ A @ Xs ) ) ) ).

% hd_append2
thf(fact_210_hd__in__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( member @ A @ ( hd @ A @ Xs ) @ ( set2 @ A @ Xs ) ) ) ).

% hd_in_set
thf(fact_211_list_Oset__sel_I1_J,axiom,
    ! [A: $tType,A5: list @ A] :
      ( ( A5
       != ( nil @ A ) )
     => ( member @ A @ ( hd @ A @ A5 ) @ ( set2 @ A @ A5 ) ) ) ).

% list.set_sel(1)
thf(fact_212_hd__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Ys ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Xs ) ) ) ) ).

% hd_append
thf(fact_213_longest__common__prefix,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
    ? [Ps: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Ps @ Xs4 ) )
      & ( Ys
        = ( append @ A @ Ps @ Ys4 ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( hd @ A @ Xs4 )
         != ( hd @ A @ Ys4 ) ) ) ) ).

% longest_common_prefix
thf(fact_214_list_Osel_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( hd @ A @ ( cons @ A @ X21 @ X22 ) )
      = X21 ) ).

% list.sel(1)
thf(fact_215_list__ex1__iff,axiom,
    ! [A: $tType] :
      ( ( list_ex1 @ A )
      = ( ^ [P3: A > $o,Xs3: list @ A] :
          ? [X2: A] :
            ( ( member @ A @ X2 @ ( set2 @ A @ Xs3 ) )
            & ( P3 @ X2 )
            & ! [Y2: A] :
                ( ( ( member @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
                  & ( P3 @ Y2 ) )
               => ( Y2 = X2 ) ) ) ) ) ).

% list_ex1_iff
thf(fact_216_can__select__set__list__ex1,axiom,
    ! [A: $tType,P: A > $o,A2: list @ A] :
      ( ( can_select @ A @ P @ ( set2 @ A @ A2 ) )
      = ( list_ex1 @ A @ P @ A2 ) ) ).

% can_select_set_list_ex1
thf(fact_217_rotate1__hd__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( rotate1 @ A @ Xs )
        = ( append @ A @ ( tl @ A @ Xs ) @ ( cons @ A @ ( hd @ A @ Xs ) @ ( nil @ A ) ) ) ) ) ).

% rotate1_hd_tl
thf(fact_218_tl__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( tl @ A @ ( append @ A @ Xs @ Ys ) )
        = ( append @ A @ ( tl @ A @ Xs ) @ Ys ) ) ) ).

% tl_append2
thf(fact_219_hd__Cons__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ Xs ) @ ( tl @ A @ Xs ) )
        = Xs ) ) ).

% hd_Cons_tl
thf(fact_220_list_Ocollapse,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) )
        = List ) ) ).

% list.collapse
thf(fact_221_in__hd__or__tl__conv,axiom,
    ! [A: $tType,L: list @ A,X: A] :
      ( ( L
       != ( nil @ A ) )
     => ( ( ( X
            = ( hd @ A @ L ) )
          | ( member @ A @ X @ ( set2 @ A @ ( tl @ A @ L ) ) ) )
        = ( member @ A @ X @ ( set2 @ A @ L ) ) ) ) ).

% in_hd_or_tl_conv
thf(fact_222_list_Oexpand,axiom,
    ! [A: $tType,List: list @ A,List2: list @ A] :
      ( ( ( List
          = ( nil @ A ) )
        = ( List2
          = ( nil @ A ) ) )
     => ( ( ( List
           != ( nil @ A ) )
         => ( ( List2
             != ( nil @ A ) )
           => ( ( ( hd @ A @ List )
                = ( hd @ A @ List2 ) )
              & ( ( tl @ A @ List )
                = ( tl @ A @ List2 ) ) ) ) )
       => ( List = List2 ) ) ) ).

% list.expand
thf(fact_223_not__hd__in__tl,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( X
       != ( hd @ A @ Xs ) )
     => ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
       => ( member @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) ) ) ) ).

% not_hd_in_tl
thf(fact_224_in__set__tlD,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) )
     => ( member @ A @ X @ ( set2 @ A @ Xs ) ) ) ).

% in_set_tlD
thf(fact_225_List_Odistinct__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ Xs )
     => ( distinct @ A @ ( tl @ A @ Xs ) ) ) ).

% List.distinct_tl
thf(fact_226_sorted__tl,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( linorder_sorted @ A @ ( tl @ A @ Xs ) ) ) ) ).

% sorted_tl
thf(fact_227_can__select__def,axiom,
    ! [A: $tType] :
      ( ( can_select @ A )
      = ( ^ [P3: A > $o,A3: set @ A] :
          ? [X2: A] :
            ( ( member @ A @ X2 @ A3 )
            & ( P3 @ X2 )
            & ! [Y2: A] :
                ( ( ( member @ A @ Y2 @ A3 )
                  & ( P3 @ Y2 ) )
               => ( Y2 = X2 ) ) ) ) ) ).

% can_select_def
thf(fact_228_list_Osel_I2_J,axiom,
    ! [A: $tType] :
      ( ( tl @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% list.sel(2)
thf(fact_229_list_Osel_I3_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( tl @ A @ ( cons @ A @ X21 @ X22 ) )
      = X22 ) ).

% list.sel(3)
thf(fact_230_Misc_Odistinct__tl,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ( ( distinct @ A @ L )
       => ( distinct @ A @ ( tl @ A @ L ) ) ) ) ).

% Misc.distinct_tl
thf(fact_231_list_Oset__sel_I2_J,axiom,
    ! [A: $tType,A5: list @ A,X: A] :
      ( ( A5
       != ( nil @ A ) )
     => ( ( member @ A @ X @ ( set2 @ A @ ( tl @ A @ A5 ) ) )
       => ( member @ A @ X @ ( set2 @ A @ A5 ) ) ) ) ).

% list.set_sel(2)
thf(fact_232_tl__obtain__elem,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ( tl @ A @ Xs )
          = ( nil @ A ) )
       => ~ ! [E2: A] :
              ( Xs
             != ( cons @ A @ E2 @ ( nil @ A ) ) ) ) ) ).

% tl_obtain_elem
thf(fact_233_Nil__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( nil @ A )
        = ( tl @ A @ Xs ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X2: A] :
            ( Xs
            = ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ) ).

% Nil_tl
thf(fact_234_tl__Nil,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( tl @ A @ Xs )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X2: A] :
            ( Xs
            = ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ) ).

% tl_Nil
thf(fact_235_tl__subset,axiom,
    ! [A: $tType,Xs: list @ A,A2: set @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A2 )
       => ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( tl @ A @ Xs ) ) @ A2 ) ) ) ).

% tl_subset
thf(fact_236_list_Oexhaust__sel,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( List
        = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ).

% list.exhaust_sel
thf(fact_237_distinct__hd__tl,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( distinct @ A @ Xs )
     => ( ( X
          = ( hd @ A @ Xs ) )
       => ~ ( member @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) ) ) ) ).

% distinct_hd_tl
thf(fact_238_list_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F22: A > ( list @ A ) > B,List: list @ A] :
      ( ( P @ ( case_list @ B @ A @ F1 @ F22 @ List ) )
      = ( ~ ( ( ( List
                = ( nil @ A ) )
              & ~ ( P @ F1 ) )
            | ( ( List
                = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) )
              & ~ ( P @ ( F22 @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ) ) ) ).

% list.split_sel_asm
thf(fact_239_list_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F22: A > ( list @ A ) > B,List: list @ A] :
      ( ( P @ ( case_list @ B @ A @ F1 @ F22 @ List ) )
      = ( ( ( List
            = ( nil @ A ) )
         => ( P @ F1 ) )
        & ( ( List
            = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) )
         => ( P @ ( F22 @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ) ) ).

% list.split_sel
thf(fact_240_list_Osimps_I5_J,axiom,
    ! [B: $tType,A: $tType,F1: B,F22: A > ( list @ A ) > B,X21: A,X22: list @ A] :
      ( ( case_list @ B @ A @ F1 @ F22 @ ( cons @ A @ X21 @ X22 ) )
      = ( F22 @ X21 @ X22 ) ) ).

% list.simps(5)
thf(fact_241_list_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,F1: B,F22: A > ( list @ A ) > B] :
      ( ( case_list @ B @ A @ F1 @ F22 @ ( nil @ A ) )
      = F1 ) ).

% list.simps(4)
thf(fact_242_list_Ocase__eq__if,axiom,
    ! [A: $tType,B: $tType] :
      ( ( case_list @ B @ A )
      = ( ^ [F12: B,F23: A > ( list @ A ) > B,List3: list @ A] :
            ( if @ B
            @ ( List3
              = ( nil @ A ) )
            @ F12
            @ ( F23 @ ( hd @ A @ List3 ) @ ( tl @ A @ List3 ) ) ) ) ) ).

% list.case_eq_if
thf(fact_243_rev__split__conv,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ( ( append @ A @ ( rev @ A @ ( tl @ A @ L ) ) @ ( cons @ A @ ( hd @ A @ L ) @ ( nil @ A ) ) )
        = ( rev @ A @ L ) ) ) ).

% rev_split_conv
thf(fact_244_remdups__adj__append,axiom,
    ! [A: $tType,Xs_1: list @ A,X: A,Xs_2: list @ A] :
      ( ( remdups_adj @ A @ ( append @ A @ Xs_1 @ ( cons @ A @ X @ Xs_2 ) ) )
      = ( append @ A @ ( remdups_adj @ A @ ( append @ A @ Xs_1 @ ( cons @ A @ X @ ( nil @ A ) ) ) ) @ ( tl @ A @ ( remdups_adj @ A @ ( cons @ A @ X @ Xs_2 ) ) ) ) ) ).

% remdups_adj_append
thf(fact_245_rev__is__rev__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( rev @ A @ Ys ) )
      = ( Xs = Ys ) ) ).

% rev_is_rev_conv
thf(fact_246_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( rev @ A @ ( rev @ A @ Xs ) )
      = Xs ) ).

% rev_rev_ident
thf(fact_247_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( nil @ A )
        = ( rev @ A @ Xs ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% Nil_is_rev_conv
thf(fact_248_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rev_is_Nil_conv
thf(fact_249_set__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rev @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rev
thf(fact_250_rev__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( rev @ A @ ( append @ A @ Xs @ Ys ) )
      = ( append @ A @ ( rev @ A @ Ys ) @ ( rev @ A @ Xs ) ) ) ).

% rev_append
thf(fact_251_distinct__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ ( rev @ A @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_rev
thf(fact_252_remdups__adj__Nil__iff,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( remdups_adj @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% remdups_adj_Nil_iff
thf(fact_253_remdups__adj__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( remdups_adj @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% remdups_adj_set
thf(fact_254_remdups__adj__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( remdups_adj @ A @ ( rev @ A @ Xs ) )
      = ( rev @ A @ ( remdups_adj @ A @ Xs ) ) ) ).

% remdups_adj_rev

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (13)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Groups_Ominus,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( minus @ A8 @ ( type2 @ A8 ) )
     => ( minus @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_1,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_2,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_3,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ominus_4,axiom,
    ! [A7: $tType] : ( minus @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_5,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_6,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_7,axiom,
    ord @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ominus_8,axiom,
    minus @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( distinct @ a @ ( sorted1267110213sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( nil @ a ) ) )
    & ( linorder_sorted @ a @ ( sorted1267110213sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( nil @ a ) ) )
    & ( ( set2 @ a @ ( sorted1267110213sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( nil @ a ) ) )
      = ( minus_minus @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ ( nil @ a ) ) ) ) ) ).

%------------------------------------------------------------------------------
